/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.idm.trident;

import com.filenet.wcm.api.ObjectFactory;
import com.filenet.wcm.api.Session;
import filenet.vw.api.VWAttachment;
import filenet.vw.base.logging.Logger;
import filenet.vw.idm.toolkit.IVWIDMDocument;
import filenet.vw.idm.toolkit.IVWIDMFactory;
import filenet.vw.idm.toolkit.IVWIDMFolder;
import filenet.vw.idm.toolkit.IVWIDMLibrary;
import filenet.vw.idm.toolkit.VWIDMBaseFactory;
import filenet.vw.idm.trident.VWIDMTridentDocument;
import filenet.vw.idm.trident.VWTridentFactoryProperties;
import filenet.ws.utils.att.IWSAttLoader;
import filenet.ws.utils.att.IWSAttSaver;
import filenet.ws.utils.att.IWSAttSession;
import filenet.ws.utils.att.IWSDocUpdater;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.Date;
import javax.activation.DataHandler;
import javax.xml.soap.AttachmentPart;

public class WSSession
implements IWSAttSession {
    protected static Logger logger = Logger.getLogger("filenet.vw.idm.trident");
    private static long TheCount = 1L;
    private static Object syncObj = new Object();
    protected static final String m_className = "trident.WSSession";
    String m_userName = null;
    String m_pw = null;
    Session m_CESession = null;
    IVWIDMFactory m_vwIDMFactory = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String GetCount() {
        String res = "0";
        Object object = syncObj;
        synchronized (object) {
            res = Long.toHexString(TheCount++);
        }
        return res;
    }

    public void setCredentials(String name, String pw) throws Exception {
        this.setCredentials(name, pw, null);
    }

    public void setCredentials(String name, String pw, File configFile) throws Exception {
        String m_method = "setCredentials:" + name;
        this.m_userName = name;
        this.m_pw = pw;
        logger.entering(m_className, m_method);
        FileInputStream configFS = null;
        try {
            this.m_CESession = ObjectFactory.getSession((String)"PEWS", (String)"Clear", (String)this.m_userName, (String)this.m_pw);
            if (configFile != null) {
                configFS = new FileInputStream(configFile);
                this.m_CESession.setConfiguration((InputStream)configFS);
            }
            VWTridentFactoryProperties factoryProperties = new VWTridentFactoryProperties();
            factoryProperties.setProperty("Session", this.m_CESession);
            factoryProperties.getCurrentUser(this.m_CESession);
            this.m_vwIDMFactory = VWIDMBaseFactory.instance("WORKPLACE");
            this.m_vwIDMFactory.setProperties(factoryProperties);
        }
        catch (Exception e) {
            logger.throwing(m_className, m_method, e);
            throw e;
        }
        finally {
            if (configFS != null) {
                try {
                    configFS.close();
                    configFS = null;
                }
                catch (Exception e) {}
            }
            logger.exiting(m_className, m_method);
        }
    }

    public IWSAttLoader getLoader(String attString) throws Exception {
        return new Loader(attString);
    }

    public IWSAttSaver getSaver(String libraryId, String folderId) throws Exception {
        return new Saver(libraryId, folderId);
    }

    public IWSDocUpdater getDocUpdater(String docId) throws Exception {
        return new Updater(docId);
    }

    public void close() {
    }

    public static String _get_FILE_DATE() {
        return "$Date:   11 Jun 2007 23:54:24  $";
    }

    public static String _get_FILE_AUTHOR() {
        return "$Author:   qdang  $";
    }

    public static String _get_FILE_REVISION() {
        return "$Revision:   1.15  $";
    }

    class Updater
    implements IWSDocUpdater {
        String m_mimeType = null;
        String m_attS = null;
        String m_id = null;
        IVWIDMDocument m_doc = null;

        public Updater(String s) throws Exception {
            this.m_attS = s;
            this.m_doc = (IVWIDMDocument)WSSession.this.m_vwIDMFactory.getIDMItem(this.m_attS);
            if (!(this.m_doc instanceof VWIDMTridentDocument)) {
                throw new Exception("Unexpected attachment type!");
            }
        }

        public void checkin(AttachmentPart[] incomingAtts, String[] userFileNames) throws Exception {
            block20: {
                String m_method = "Updater.checkin";
                logger.entering(WSSession.m_className, "Updater.checkin");
                InputStream is = null;
                try {
                    int nAtts;
                    int n = nAtts = incomingAtts == null ? 0 : incomingAtts.length;
                    if (nAtts == 0) {
                        return;
                    }
                    InputStream[] ins = new InputStream[nAtts];
                    String[] mimeTypes = new String[nAtts];
                    for (int i = 0; i < nAtts; ++i) {
                        DataHandler dh = incomingAtts[i].getDataHandler();
                        if (dh == null) {
                            throw new Exception("NO HANDLER!");
                        }
                        ins[i] = dh.getInputStream();
                        if (ins[i] != null && logger.isFinest()) {
                            logger.finest(WSSession.m_className, "Updater.checkin", "use DataHandler=" + ins[i].getClass().getName());
                        }
                        if (ins[i] == null) {
                            throw new Exception("Unable to retrieve attachment stream..");
                        }
                        mimeTypes[i] = incomingAtts[i].getContentType();
                    }
                    if (this.m_doc.canCheckout()) {
                        this.m_doc.markCheckout();
                        this.m_doc.refresh();
                    }
                    if (this.m_doc.canCheckin()) {
                        this.m_doc.checkinFromStreams(ins, userFileNames, mimeTypes);
                        break block20;
                    }
                    throw new Exception("Unable to save the attachments due to insufficient checkin privileges for " + WSSession.this.m_userName + " for doc=" + this.m_doc);
                }
                catch (Exception e) {
                    logger.throwing(WSSession.m_className, "Updater.checkin", e);
                    throw e;
                }
                finally {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (Exception e) {}
                    }
                    logger.exiting(WSSession.m_className, "Updater.checkin");
                }
            }
        }

        public String toString() {
            return this.m_attS;
        }
    }

    class Loader
    implements IWSAttLoader {
        String m_mimeType = null;
        String m_attS = null;
        String m_id = null;
        IVWIDMDocument m_doc = null;

        public Loader(String s) throws Exception {
            this.m_attS = s;
            VWAttachment m_att = new VWAttachment(s);
            this.m_id = m_att.getId() + WSSession.GetCount();
            this.m_doc = (IVWIDMDocument)WSSession.this.m_vwIDMFactory.getIDMItemFromVWAttachment(m_att);
            if (!(this.m_doc instanceof VWIDMTridentDocument)) {
                throw new Exception("Unexpected attachment type!");
            }
            try {
                this.m_mimeType = (String)this.m_doc.getProp("MimeType");
            }
            catch (Exception e) {
                this.m_mimeType = "application/binary";
            }
        }

        public InputStream[] getContentStreams() throws Exception {
            return this.m_doc.getContentStreams();
        }

        public byte[] getContents() throws Exception {
            return this.m_doc.getContents();
        }

        public String getId() {
            return this.m_id;
        }

        public String getLabel() {
            return this.m_doc.getLabel();
        }

        public String getFileName() {
            return this.m_doc.getFileName();
        }

        public String getMimeType() {
            return this.m_mimeType;
        }

        public void setMimeType(String s) {
            this.m_mimeType = s;
        }

        public String toString() {
            return this.m_attS;
        }
    }

    class Saver
    implements IWSAttSaver {
        String m_libId = null;
        String m_folderId = null;
        IVWIDMLibrary m_lib = null;
        IVWIDMFolder m_folder = null;

        public VWAttachment saveAttachment(AttachmentPart incomingAtt, String docTitle, String docFileName) throws Exception {
            String m_method = "Saver.saveAttachment";
            logger.entering(WSSession.m_className, "Saver.saveAttachment");
            InputStream is = null;
            try {
                if (incomingAtt == null) {
                    VWAttachment vWAttachment = null;
                    return vWAttachment;
                }
                is = incomingAtt.getDataHandler().getInputStream();
                if (is == null) {
                    throw new Exception("Unable to retrieve attachment stream..");
                }
                if (docFileName == null) {
                    docFileName = "POATT";
                }
                if (docTitle == null) {
                    docTitle = new Date().toString();
                }
                if (logger.isFinest()) {
                    logger.finest(WSSession.m_className, "Saver.saveAttachment", "docFileName=" + docFileName + ", docTitle=" + docTitle);
                }
                if (this.m_lib == null) {
                    throw new Exception("Invalid library..");
                }
                if (this.m_folder == null) {
                    throw new Exception("Invalid folder..");
                }
                IVWIDMDocument newDoc = this.m_lib.createDocumentFromStream("{01A3A8C2-7AEC-11D1-A31B-0020AF9FBB1C}", this.m_folder, docFileName, new String[]{"DocumentTitle", "MimeType"}, new String[]{docTitle, incomingAtt.getContentType()}, null, null, null, is);
                VWAttachment vWAttachment = newDoc.getVWAttachment();
                return vWAttachment;
            }
            catch (Exception e) {
                logger.throwing(WSSession.m_className, "Saver.saveAttachment", e);
                throw e;
            }
            finally {
                if (is != null) {
                    try {
                        is.close();
                    }
                    catch (Exception e) {}
                }
                logger.exiting(WSSession.m_className, "Saver.saveAttachment");
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Saver(String libId, String folderId) throws Exception {
            String m_method = "Saver:ctor:" + libId + ":" + folderId;
            logger.entering(WSSession.m_className, m_method);
            try {
                this.m_libId = libId;
                this.m_folderId = folderId;
                this.m_lib = WSSession.this.m_vwIDMFactory.getIDMLibrary(libId);
                this.m_folder = this.m_lib.getFolder(folderId);
            }
            finally {
                logger.exiting(WSSession.m_className, m_method);
            }
        }

        public String toString() {
            if (this.m_folder != null && this.m_lib != null) {
                return "Saver:folder=" + this.m_folder.getName() + ",lib=" + this.m_lib.getName();
            }
            return "INVALID_SAVER";
        }
    }
}

